<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'min_amount', 'price_avg', 'rate', 'created_by', 'updated_by');

    public function stocks()
    {
        return $this->hasMany('App\Models\Store', 'item_id');
    }

}